//
// Go over the container of all EventGroup bjects. See which one has a matching UID, then trigger that one.
/******************************************************************************/
void TriggerNextNode(UID id)
{
   REPAD(i, eventBehaviours)
   {
      if(eventBehaviours[i].id() == id)
      {
         eventBehaviours[i].Triggered();
         break;
      }
   }
}

//
// This is the base class for all events that you want to create. It loads in the most basic parameters (like Delay and Duration) that are used in every event.
// 
/******************************************************************************/
class LinkableNode : Game.Obj
{
public:
            LinkableNode();
   virtual ~LinkableNode();
   
   // Override the create() in each inherited class to load your own parameters. If you do, don't forget to call super.create();
   virtual void create(Game.ObjParams &obj) { } 

   // Override the update() only to add your own logic that needs updating.      If you do, don't forget to call super.update();
   virtual Bool update() { return true; }
   virtual UInt drawPrepare() { return 0 ;}
   
   virtual Vec    pos   (                ) { return 0; } // get position
   virtual void   pos   (C Vec    &pos   ) {           } // set position
   virtual Matrix matrix(                ) { return 0; } // get matrix
   virtual void   matrix(C Matrix &matrix) {           } // set matrix, for most classes 'matrix' should be normalized 
   
   virtual void Triggered() { }
   
private:

};
/******************************************************************************/
LinkableNode::LinkableNode()                   
{
   
}
LinkableNode::~LinkableNode()
{
   
}
/******************************************************************************/